//******************************************************************************
// Copyright (c) ACE CAD Enterprise Co., Ltd.  All rights reserved.            *
//                                                                             *
// This source code is subject to demostrate the decoding of the ACECAD Ink    *
// file (.DHW file). The code and information provided here is for reference   *
// purpose only. Please refers to the ACECAD Ink File Format document for the  *
// detailed description of the Ink data.                                       *
// *****************************************************************************
//
// DHWSampleView.cpp : implementation of the CDHWSampleView class
//

#include "stdafx.h"
#include "DHWSample.h"

#include "DHWSampleDoc.h"
#include "DHWSampleView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView

extern double tablet_width,tablet_height;
CRect Handwriting_Rect(0,0,0,0);
extern CArray<Point_Record,Point_Record> ptArray;

IMPLEMENT_DYNCREATE(CDHWSampleView, CView)

BEGIN_MESSAGE_MAP(CDHWSampleView, CView)
	//{{AFX_MSG_MAP(CDHWSampleView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView construction/destruction

CDHWSampleView::CDHWSampleView()
{
	// TODO: add construction code here
	Screen_Rect.SetRect(0,0,0,0);
}

CDHWSampleView::~CDHWSampleView()
{
}

BOOL CDHWSampleView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView drawing

void CDHWSampleView::OnDraw(CDC* pDC)
{
	CDHWSampleDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	if(Screen_Rect==CRect(0,0,0,0))
	{
		::GetClientRect(this->m_hWnd,&Screen_Rect);
        Handwriting_Rect=Screen_Rect;
		Handwriting_Rect.right=Screen_Rect.bottom/7*5;
		Handwriting_Rect.bottom=(Screen_Rect.bottom/7)*7;
	}
	CBrush Gray_brush(RGB(192,192,192)),White_brush(RGB(255,255,255));
	pDC->FillRect(&Screen_Rect,&Gray_brush);
	pDC->FillRect(&Handwriting_Rect,&White_brush);

	if(ptArray.GetSize()==0) return;
	CPen BlackPen(PS_SOLID, 1, RGB(0,0,0));
	CPen RedPen(PS_SOLID, 1, RGB(255,0,0));
	CPen BluePen(PS_SOLID, 1, RGB(0,0,255));
	CPen GreenPen(PS_SOLID, 1, RGB(0,255,0));
	CPen* oldpen;
	struct Point_Record P_Record;
	POINT oldpoint;
	oldpoint.x=0;
	oldpoint.y=0;
	BOOL PenDown=FALSE;

	for(int q=0;q<ptArray.GetSize();q++)
	{
		P_Record=ptArray.GetAt(q);
		if((P_Record.PenState%2)==1)
		{
			switch(P_Record.PenState)
			{
			case 0x81:oldpen=pDC->SelectObject(&BlackPen);break;
			case 0x83:oldpen=pDC->SelectObject(&RedPen);break;
			case 0x85:oldpen=pDC->SelectObject(&BluePen);break;
			case 0x87:oldpen=pDC->SelectObject(&GreenPen);break;
			default:oldpen=pDC->SelectObject(&BlackPen);break;
			}
			if(PenDown==TRUE)
			{
				pDC->MoveTo(oldpoint);
				pDC->LineTo(P_Record.pt);
				oldpoint=P_Record.pt;
			}
			else
			{
				pDC->MoveTo(P_Record.pt);
				pDC->LineTo(P_Record.pt);
				oldpoint=P_Record.pt;
				PenDown=TRUE;
			}
			pDC->SelectObject(oldpen);
		}
		else
		{
			switch(P_Record.PenState)
			{
			case 0x80:oldpen=pDC->SelectObject(&BlackPen);break;
			case 0x82:oldpen=pDC->SelectObject(&RedPen);break;
			case 0x84:oldpen=pDC->SelectObject(&BluePen);break;
			case 0x86:oldpen=pDC->SelectObject(&GreenPen);break;
			default:oldpen=pDC->SelectObject(&BlackPen);break;
			}
			if(PenDown==TRUE)
			{
				pDC->MoveTo(oldpoint);
				pDC->LineTo(P_Record.pt);
				oldpoint=P_Record.pt;
			}
			pDC->SelectObject(oldpen);
			PenDown=FALSE;
		}
    }
}

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView printing

BOOL CDHWSampleView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CDHWSampleView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CDHWSampleView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView diagnostics

#ifdef _DEBUG
void CDHWSampleView::AssertValid() const
{
	CView::AssertValid();
}

void CDHWSampleView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDHWSampleDoc* CDHWSampleView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDHWSampleDoc)));
	return (CDHWSampleDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDHWSampleView message handlers
